﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using CashierCrisis.Managers;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Input;

namespace CashierCrisis.UserInterface
{
    public class PauseUI : UI
    {
        UIText pauseText;
        UIButton resumeButton;
        UIButton exitButton;
        InputManager input;

        public PauseDelegate PauseToggle;

        public PauseUI(Game game)
            : base(game)
        {
            FontManager fontManager = CashierGame.Instance.Services.GetService(typeof(FontManager)) as FontManager;
            EntityManager entityManager = CashierGame.Instance.Services.GetService(typeof(EntityManager)) as EntityManager;
            PauseToggle += entityManager.Paused;
            SpriteFont font = fontManager.GetFont("Default");
            input = CashierGame.Instance.Services.GetService(typeof(InputManager)) as InputManager; ;

            pauseText = new UIText("Pause");
            pauseText.Font = font;
            pauseText.Position = new Vector2(SceneManager.CenterAlign - 100, 250);
            pauseText.Active = false;

            resumeButton = new UIButton("Resume", Color.Yellow);
            resumeButton.Position = new Vector2(SceneManager.CenterAlign - 100, 300);
            resumeButton.Font = font;

            exitButton = new UIButton("Exit to Main Menu", Color.Yellow);
            exitButton.Position = new Vector2(SceneManager.CenterAlign - 100, 350);
            exitButton.Font = font;

            AddWidget(pauseText);
            AddWidget(resumeButton);
            AddWidget(exitButton);
            Visible = true;

        }

        public override void Update(Microsoft.Xna.Framework.GameTime gameTime)
        {
        

            if (input.UpButton())
            {
                PreviousWidget();
            }

            if (input.DownButton())
            {
                NextWidget();
            }

            if (input.ConfirmButton())
            {
                IButton button = (IButton)SelectedWidget();
                button.OnPressed();
            }

            base.Update(gameTime);
        }

        public override void WidgetCallback(UIWidget widget)
        {
            if (widget == resumeButton)
            {
                UIManager.PopUserInterface();
                PauseToggle(false);
            }

            if (widget == exitButton)
            {
                SceneManager.ChangeScene("MainMenu");
                UIManager.PopUserInterface();
                UIManager.SwapUserInterface("MainMenu");
            }
        }

        
    }
}
